<?php include("connect.php"); ?>
<?php
// 1. Get Laravel's session ID from the vinance_session cookie
if (!isset($_COOKIE['vinance_session'])) {
    die("No Laravel session cookie found.");
}

$sessionId = $_COOKIE['vinance_session'];

// 2. Path to Laravel's session storage
$sessionPath = __DIR__ . '/core/storage/framework/sessions/' . $sessionId;

if (!file_exists($sessionPath)) {
    die("Session file not found.");
}

// 3. Read the file content
$contents = file_get_contents($sessionPath);

// 4. Remove Laravel's metadata
if (preg_match('/^.+?\|/', $contents, $matches)) {
    $contents = substr($contents, strlen($matches[0]));
}

// 5. Unserialize session data
$sessionData = unserialize($contents);

// 6. Get logged-in user ID from login_web_* key
$userId = null;
foreach ($sessionData as $key => $value) {
    if (strpos($key, 'login_web_') === 0) {
        $userId = $value;
        break;
    }
}

// Only echo if no login is found
if (!$userId) {
    echo "No active login found.";
}
else{
    echo $userId;
}
?>
<?php
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Assume you have logged-in user's ID in session
    $user_id = $userId; 
    $tname = mysqli_real_escape_string($conn, $_POST['tname']);

    $sql = "INSERT INTO cdetails (user_id, tname) VALUES ('$user_id', '$tname')";

    if (mysqli_query($conn, $sql)) {
        echo "Trader copied successfully.";
    } else {
        echo "Error: " . mysqli_error($conn);
    }

    mysqli_close($conn);
} else {
    echo "Invalid request.";
}
?>