<?php $__env->startSection('content'); ?>
    <?php
        $walletBalance = showAmount($wallet->balance, currencyFormat: false);
        $general = gs();
        $transferCharge = getAmount($general->other_user_transfer_charge);
        $transferChargeForOtherWallet = getAmount($general->other_wallet_transfer_charge);
    ?>
    <div class="row gy-3 justify-content-center mb-3">
        <div class="col-lg-12">
            <div class="d-flex flex-wrap flex-between align-items-center">
                <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
                <a href="<?php echo e(route('user.wallet.list', $walletType)); ?>" class="btn btn--base btn--sm outline">
                    <i class="la la-undo"></i> <?php echo app('translator')->get('Back'); ?>
                </a>
            </div>
        </div>
    </div>
    <div class="row gy-4 mb-3 justify-content-center">
        <div class="col-xxl-3 col-sm-6">
            
            <div class="dashboard-card ">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--base">
                        <i class="las la-spinner"></i>
                    </span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.order.open')); ?>?currency=<?php echo e($currency->symbol); ?>" class="dashboard-card__coin-name mb-0 ">
                            <?php echo app('translator')->get('Open Order'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title"> <?php echo e(getAmount(@$widget['open_order'])); ?> </h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card ">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--success">
                        <i class="las la-check-circle"></i>
                    </span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.order.completed')); ?>?currency=<?php echo e($currency->symbol); ?>" class="dashboard-card__coin-name mb-0">
                            <?php echo app('translator')->get('Completed Order'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title"> <?php echo e(getAmount(@$widget['completed_order'])); ?>

                        </h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card ">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--danger">
                        <i class="las la-times-circle"></i>
                    </span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.order.canceled')); ?>?currency=<?php echo e($currency->symbol); ?>" class="dashboard-card__coin-name mb-0 ">
                            <?php echo app('translator')->get('Canceled Order'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title"> <?php echo e(getAmount(@$widget['canceled_order'])); ?></h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--base fs-50 icon-order"></span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.order.history')); ?>?search=<?php echo e(@$currency->symbol); ?>" class="dashboard-card__coin-name mb-0">
                            <?php echo app('translator')->get('Total Order'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title">
                            <?php echo e(getAmount($widget['total_order'])); ?>

                        </h6>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row gy-3 mb-3 justify-content-center">
        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--base fs-50 icon-deposit"></span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.deposit.history')); ?>?search=<?php echo e(@$currency->symbol); ?>" class="dashboard-card__coin-name mb-0">
                            <?php echo app('translator')->get('Total Deposit'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title">
                            <?php echo e(__(@$wallet->currency->sign)); ?><?php echo e(showAmount($widget['total_deposit'], currencyFormat: false)); ?>

                        </h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--base fs-50 icon-withdraw">
                    </span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.withdraw.history')); ?>?search=<?php echo e(@$currency->symbol); ?>" class="dashboard-card__coin-name mb-0 ">
                            <?php echo app('translator')->get('Total Withdraw'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title">
                            <?php echo e(__(@$wallet->currency->sign)); ?><?php echo e(showAmount($widget['total_withdraw'], currencyFormat: false)); ?>

                        </h6>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--base fs-50 icon-transaction"></span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.transactions')); ?>?symbol=<?php echo e(@$currency->symbol); ?>&wallet_type=<?php echo e($walletType); ?>"
                            class="dashboard-card__coin-name mb-0">
                            <?php echo app('translator')->get('Total Transaction'); ?>
                        </a>
                        <h6 class="dashboard-card__coin-title">
                            <?php echo e(getAmount($widget['total_transaction'])); ?>

                        </h6>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xxl-3 col-sm-6">
            <div class="dashboard-card ">
                <div class="d-flex justify-content-between align-items-center">
                    <span class="dashboard-card__icon text--base">
                        <span class="icon-trade fs-50"></span>
                    </span>
                    <div class="dashboard-card__content">
                        <a href="<?php echo e(route('user.trade.history')); ?>" class="dashboard-card__coin-name mb-0"><?php echo app('translator')->get('Total Trade'); ?> </a>
                        <h6 class="dashboard-card__coin-title"> <?php echo e(getAmount(@$widget['total_trade'])); ?> </h6>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="row gy-3 mb-3 justify-content-center">
        <div class="col-lg-12 col-xl-4">
            <div class="card border-0 mb-3">
                <div class="card-body">
                    <div class="wallet-currency text-center mb-3">
                        <img src="<?php echo e(@$wallet->currency->image_url); ?>">
                        <div class="">
                            <p class="mb-0 fs-16"><?php echo e(__(@$wallet->currency->name)); ?></p>
                            <p class="mt-0 fs-12"><?php echo e(__(@$wallet->currency->symbol)); ?></p>
                        </div>
                    </div>
                    <div class="wallet-ballance p-3 mb-3">
                        <p class="mb-0 fs-16"><?php echo e(__(@$wallet->currency->sign)); ?><?php echo e(showAmount($wallet->balance, currencyFormat: false)); ?>

                        </p>
                        <p class="mt-0 fs-12"><?php echo app('translator')->get('Available Balance'); ?></p>
                    </div>
                    <div class="d-flex flex-wrap gap-2 mb-3">
                        <div class="flex-fill wallet-ballance p-3 mt-3">
                            <p class="mb-0 fs-16">
                                <?php echo e(__(@$wallet->currency->sign)); ?><?php echo e(showAmount($wallet->in_order, currencyFormat: false)); ?></p>
                            <p class="mt-0 fs-12"><?php echo app('translator')->get('In Order'); ?></p>
                        </div>
                        <div class="flex-fill wallet-ballance p-3 mt-3 ">
                            <p class="mb-0 fs-16">
                                <?php echo e(__(@$wallet->currency->sign)); ?><?php echo e(showAmount($wallet->total_balance, currencyFormat: false)); ?></p>
                            <p class="mt-0 fs-12"><?php echo app('translator')->get('Total Balance'); ?></p>
                        </div>
                    </div>
                    <div class="d-flex flex-wrap gap-2">
                        <?php if(checkWalletConfiguration($walletType, 'deposit')): ?>
                            <button type="button" class="btn btn--success outline flex-fill btn--sm depositBtn">
                                <span class="icon-deposit"></span> <?php echo app('translator')->get('Deposit'); ?>
                            </button>
                        <?php endif; ?>

                        <?php if(checkWalletConfiguration($walletType, 'withdraw')): ?>
                            <button type="button" class="btn btn--danger outline flex-fill btn--sm withdrawBtn">
                                <span class="icon-withdraw"></span> <?php echo app('translator')->get('Withdraw'); ?>
                            </button>
                        <?php endif; ?>

                        <?php if(checkWalletConfiguration($walletType, 'transfer_other_user') || checkWalletConfiguration($walletType, 'transfer_other_wallet')): ?>
                            <button type="button" class="btn btn--base outline flex-fill btn--sm transferBtn">
                                <i class="las la-exchange-alt"></i> <?php echo app('translator')->get('Transfer'); ?>
                            </button>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12 col-xl-8">
            <div class="card custom--card border-0">
                <div class="card-body p-0">
                    <h4 class="card-title"><?php echo app('translator')->get('Transaction History'); ?></h4>
                    <table class="table table--responsive--lg">
                        <thead>
                            <tr>
                                <th><?php echo app('translator')->get('Transacted'); ?></th>
                                <th><?php echo app('translator')->get('Trx'); ?></th>
                                <th><?php echo app('translator')->get('Amount'); ?></th>
                                <th><?php echo app('translator')->get('Post Balance'); ?></th>
                                <th><?php echo app('translator')->get('Detail'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <div>
                                            <?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?>

                                        </div>
                                    </td>
                                    <td>
                                        <strong><?php echo e($trx->trx); ?></strong>
                                    </td>
                                    <td class="budget">
                                        <span class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                                            <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount, currencyFormat: false)); ?>

                                            <?php echo e(__($trx->wallet->currency->symbol)); ?>

                                        </span>
                                    </td>
                                    <td class="budget"> <?php echo e(showAmount($trx->post_balance, currencyFormat: false)); ?>

                                        <?php echo e(__($trx->wallet->currency->symbol)); ?>

                                    </td>
                                    <td><?php echo e(__($trx->details)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php echo userTableEmptyMessage('transaction') ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <?php if($transactions->hasPages()): ?>
                <?php echo e(paginateLinks($transactions)); ?>

            <?php endif; ?>
        </div>
    </div>

    <?php if(checkWalletConfiguration($walletType, 'deposit')): ?>
        <?php if (isset($component)) { $__componentOriginalb4d7a76f273e1ce6275894d99e164dac = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb4d7a76f273e1ce6275894d99e164dac = $attributes; } ?>
<?php $component = App\View\Components\FlexibleView::resolve(['view' => $activeTemplate . 'user.components.canvas.deposit','meta' => ['gateways' => $gateways, 'single_currency' => $currency, 'wallet_type' => $walletType]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flexible-view'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\FlexibleView::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb4d7a76f273e1ce6275894d99e164dac)): ?>
<?php $attributes = $__attributesOriginalb4d7a76f273e1ce6275894d99e164dac; ?>
<?php unset($__attributesOriginalb4d7a76f273e1ce6275894d99e164dac); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb4d7a76f273e1ce6275894d99e164dac)): ?>
<?php $component = $__componentOriginalb4d7a76f273e1ce6275894d99e164dac; ?>
<?php unset($__componentOriginalb4d7a76f273e1ce6275894d99e164dac); ?>
<?php endif; ?>
    <?php endif; ?>

    <?php if(checkWalletConfiguration($walletType, 'withdraw')): ?>
        <?php if (isset($component)) { $__componentOriginalb4d7a76f273e1ce6275894d99e164dac = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb4d7a76f273e1ce6275894d99e164dac = $attributes; } ?>
<?php $component = App\View\Components\FlexibleView::resolve(['view' => $activeTemplate . 'user.components.canvas.withdraw','meta' => [
            'withdrawMethods' => $withdrawMethods,
            'single_currency' => $currency,
            'wallet_type' => $walletType,
        ]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flexible-view'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\FlexibleView::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb4d7a76f273e1ce6275894d99e164dac)): ?>
<?php $attributes = $__attributesOriginalb4d7a76f273e1ce6275894d99e164dac; ?>
<?php unset($__attributesOriginalb4d7a76f273e1ce6275894d99e164dac); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb4d7a76f273e1ce6275894d99e164dac)): ?>
<?php $component = $__componentOriginalb4d7a76f273e1ce6275894d99e164dac; ?>
<?php unset($__componentOriginalb4d7a76f273e1ce6275894d99e164dac); ?>
<?php endif; ?>
    <?php endif; ?>

    <?php if(checkWalletConfiguration($walletType, 'transfer_other_user') || checkWalletConfiguration($walletType, 'transfer_other_wallet')): ?>
        <div class="offcanvas offcanvas-end" tabindex="-1" id="transfer-offcanvas" aria-labelledby="offcanvasLabel">
            <div class="offcanvas-header">
                <h4 class="mb-0 fs-18 offcanvas-title">
                    <?php echo app('translator')->get("Transfer $currency->symbol"); ?>
                </h4>
                <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close">
                    <i class="fa fa-times-circle"></i>
                </button>
            </div>
            <div class="offcanvas-body">
                <ul class="nav nav-pills custom--tab" id="pills-tab" role="tablist">
                    <?php if(checkWalletConfiguration($walletType, 'transfer_other_user')): ?>
                        <li class="nav-item transfer-type" data-transfer-type="user">
                            <button class="nav-link active" type="button"><?php echo app('translator')->get('Other Users'); ?></button>
                        </li>
                    <?php endif; ?>

                    <?php if(checkWalletConfiguration($walletType, 'transfer_other_wallet')): ?>
                        <li class="nav-item transfer-type" data-transfer-type="wallet">
                            <button class="nav-link" type="button"><?php echo app('translator')->get('Other Wallet'); ?></button>
                        </li>
                    <?php endif; ?>
                </ul>
                <?php if(checkWalletConfiguration($walletType, 'transfer_other_user')): ?>
                    <form action="<?php echo e(route('user.wallet.transfer')); ?>" method="post" class="other-user-transfer transfer-wrapper ">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="currency" value="<?php echo e($currency->id); ?>">
                        <input type="hidden" name="wallet_type" value="<?php echo e($walletType); ?>">
                        <p class="border--base p-3 mb-3 rounded border">
                            <?php echo app('translator')->get("Fund transfer of $currency->symbol within the $general->site_name platform, allowing for the allocation of a maximum of $walletBalance $currency->symbol to another user, while bearing in mind a nominal $transferCharge% transaction fee."); ?>
                        </p>
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Username'); ?></label>
                            <input type="text" class="form--control form-control" name="username" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label"><?php echo app('translator')->get('Amount'); ?></label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <?php echo e(@$currency->sign); ?>

                                </span>
                                <input type="number" step="any" class="form-control form--control" name="transfer_amount" required />
                                <span class="input-group-text max cursor-pointer other-user-transfer-max"
                                    data-max="<?php echo e(getAmount($wallet->balance)); ?>"><?php echo app('translator')->get('MAX'); ?></span>
                            </div>
                        </div>
                        <div class="form-group transfer-details d-none">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item d-flex flex-wrap justify-content-between">
                                    <span><?php echo app('translator')->get('Amount'); ?></span>
                                    <span>
                                        <span class="transfer-amount"></span>
                                        <span><?php echo e($currency->symbol); ?></span>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex flex-wrap justify-content-between">
                                    <span><?php echo app('translator')->get('Charge'); ?></span>
                                    <span>
                                        <span class="transfer-charge"></span>
                                        <span><?php echo e($currency->symbol); ?></span>
                                        <span class="fs-12">(<?php echo e($transferCharge); ?>%)</span>
                                    </span>
                                </li>
                                <li class="list-group-item d-flex flex-wrap justify-content-between">
                                    <span><?php echo app('translator')->get('Amount with charge'); ?></span>
                                    <span>
                                        <span class="transfer-total-amount"></span>
                                        <span><?php echo e($currency->symbol); ?></span>
                                    </span>
                                </li>
                            </ul>
                        </div>
                        <button class="btn btn--base w-100" type="submit"> <?php echo app('translator')->get('Submit'); ?> </button>
                    </form>
                <?php endif; ?>

                <?php if(checkWalletConfiguration($walletType, 'transfer_other_wallet')): ?>
                    <form action="<?php echo e(route('user.wallet.transfer.to.other.wallet')); ?>" method="post"
                        class="<?php if(checkWalletConfiguration($walletType, 'transfer_other_user')): ?> d-none <?php endif; ?> other-wallet-transfer transfer-wrapper">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="currency" value="<?php echo e($currency->id); ?>">
                        <input type="hidden" name="from_wallet" value="<?php echo e($walletType); ?>">

                        <p class="border--base p-3 mb-3 rounded border">
                            <?php echo app('translator')->get("Fund transfer of $currency->symbol within the $general->site_name platform, allowing for the allocation of a maximum of $walletBalance $currency->symbol to other wallet."); ?>
                        </p>
                        <div class="form-group">
                            <label class="form--label"><?php echo app('translator')->get('Amount'); ?></label>
                            <div class="input-group">
                                <span class="input-group-text">
                                    <?php echo e(@$currency->sign); ?>

                                </span>
                                <input type="number" step="any" class="form-control form--control" name="transfer_amount" required />
                                <span class="input-group-text max cursor-pointer"
                                    data-max="<?php echo e(getAmount($wallet->balance)); ?>"><?php echo app('translator')->get('MAX'); ?></span>
                            </div>
                        </div>
                        <div class="form-group position-relative">
                            <label class="form--label"><?php echo app('translator')->get('To Wallet'); ?></label>
                            <select class="form--control form-select select2" name="to_wallet" required data-minimum-results-for-search="-1"
                                data-width="100%">
                                <option selected disabled><?php echo app('translator')->get('Select One'); ?></option>
                                <?php $__currentLoopData = gs('wallet_types'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php if($wallet->name != $walletType): ?>
                                        <option value="<?php echo e($wallet->name); ?>"><?php echo e(__($wallet->title)); ?></option>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <button class="btn btn--base w-100" type="submit"> <?php echo app('translator')->get('Submit'); ?> </button>
                    </form>
                <?php endif; ?>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            $('.depositBtn').on('click', function(e) {
                canvasShow("deposit-canvas");
            });

            $('.withdrawBtn').on('click', function(e) {
                canvasShow("withdraw-offcanvas");
            });

            $('.transferBtn').on('click', function(e) {
                canvasShow("transfer-offcanvas");
            });

            function canvasShow(id) {
                let myOffcanvas = document.getElementById(id);
                new bootstrap.Offcanvas(myOffcanvas).show();
            }

            $(".other-user-transfer input[name=transfer_amount]").on('input change', function() {

                const amount = parseFloat($(this).val());

                if (!amount || amount <= 0) {
                    $(".other-user-transfer").find('.transfer-details').addClass('d-none');
                    return;
                }

                const chargePercent = parseFloat("<?php echo e($transferCharge); ?>");
                const chargeAmount = (amount / 100) * chargePercent;
                const totalAmount = amount + chargeAmount;

                $(".other-user-transfer").find('.transfer-amount').text(getAmount(amount));
                $(".other-user-transfer").find('.transfer-charge').text(getAmount(chargeAmount));
                $(".other-user-transfer").find('.transfer-total-amount').text(getAmount(totalAmount));
                $(".other-user-transfer").find('.transfer-details').removeClass('d-none');
            });

            $('.transfer-type').on('click', function(e) {
                let transferType = $(this).data('transfer-type');
                $('.transfer-type').find(`button`).removeClass('active');
                $(this).find(`button`).addClass('active');
                $(`.transfer-wrapper`).addClass('d-none');
                $(`.other-${transferType}-transfer`).removeClass('d-none');
            });

            $('.max').on('click', function(e) {
                const max = $(this).data('max');
                $(this).closest('div').find(`input`).val(max);
                if ($(this).hasClass('other-user-transfer-max')) {
                    $(".other-user-transfer input[name=transfer_amount]").trigger('change');
                }
            });

        
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .wallet-currency img {
            width: 70px;
            border-radius: 50%;
            object-fit: cover;
        }

        .wallet-ballance {
            background-color: #09171a;
        }

        .offcanvas {
            padding: 30px;
        }

        .custom--tab {
            justify-content: flex-start;
            border-radius: 0;
            border-bottom: 2px solid hsl(var(--white)/0.1);
            border-radius: 4px;
            padding: 10px;
            padding-bottom: 15px;
            margin-bottom: 0px !important;
            margin-bottom: 25px !important;
            background-color: #0d2227;
        }

        .custom--tab .nav-item {
            padding: 0;
            width: 50%;
            display: flex;
            justify-content: center;
            cursor: pointer;
        }

        .custom--tab .nav-item .nav-link {
            background-color: transparent !important;
            border-radius: 0;
            border: 0 !important;
            padding: 0 50px !important;
            position: relative;
            font-size: 1rem;
            font-weight: 600;
        }

        .custom--tab .nav-item .nav-link.active::before {
            position: absolute;
            content: "";
            left: 0;
            bottom: -5px;
            width: 100%;
            height: 2px;
            background-color: hsl(var(--base));
            display: none;
            font-weight: normal;
        }

        .custom--tab .nav-item .nav-link::after {
            position: absolute;
            content: "";
            bottom: -17px;
            left: 0;
            width: 0;
            height: 1px;
            background-color: hsl(var(--base)) !important;
        }

        .custom--tab .nav-item .nav-link.active {
            color: hsl(var(--base)) !important;
            background-color: transparent !important;
        }

        .custom--tab .nav-item .nav-link.active.nav-link::after {
            width: 100%;
        }

        .custom--tab .nav-item .nav-link.active:hover {
            color: hsl(var(--base)) !important;
        }

        @media screen and (max-width:991px) {
            .offcanvas {
                padding: 20px;
            }

            .custom--tab .nav-item .nav-link {
                padding: 0 20px !important;
            }
        }

        @media screen and (max-width:991px) {
            .offcanvas {
                padding: 15px;
            }

            .custom--tab .nav-item .nav-link {
                padding: 0 10px !important;
                font-size: 15px;
            }
        }

        .select2-image {
            max-width: 50px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/wallet/view.blade.php ENDPATH**/ ?>