<?php $__env->startSection('content'); ?>
    <div class="row justify-content-between align-items-center gy-4">
        <div class="col-lg-4">
            <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
        </div>
        <div class="col-lg-3">
            <form>
                <div class="input-group">
                    <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>" placeholder="<?php echo app('translator')->get('Search by transactions'); ?>">
                    <button class="input-group-text bg-primary text-white">
                        <i class="las la-search"></i>
                    </button>
                </div>
            </form>
        </div>
        <div class="col-md-12">
            <div class="table-wrapper">
                <table class="table table--responsive--lg">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Currency | Wallet'); ?></th>
                            <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                            <th><?php echo app('translator')->get('Initiated'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Details'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $symbol = @$deposit->wallet->currency->symbol;
                            ?>
                            <tr>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <span><?php echo e($symbol); ?></span>
                                        <br>
                                        <small><?php echo e(@$deposit->wallet->name); ?> | <?php echo e(__(strToUpper(@$deposit->wallet->type_text))); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <span class="text-primary fw-bold"><?php echo e(__($deposit->gateway?->name)); ?></span>
                                        <br>
                                        <small> <?php echo e($deposit->trx); ?> </small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-end text-lg-start fw-normal">
                                        <span><?php echo e(showDateTime($deposit->created_at)); ?></span> <br>
                                        <small><?php echo e(diffForHumans($deposit->created_at)); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-end text-lg-start fw-normal">
                                        <?php echo e(showAmount($deposit->amount, currencyFormat: false)); ?> +
                                        <span class="text--danger" title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($deposit->charge, currencyFormat: false)); ?>

                                        </span>
                                        <br>
                                        <span title="<?php echo app('translator')->get('Amount with charge'); ?>">
                                            <?php echo e(showAmount($deposit->amount + $deposit->charge, currencyFormat: false)); ?>

                                            <?php echo e($symbol); ?>

                                        </span>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="text-end text-lg-start">
                                        <?php echo $deposit->statusBadge ?>
                                    </div>
                                </td>
                                <?php
                                    $details = $deposit->detail != null ? json_encode($deposit->detail) : null;
                                ?>
                                <td>
                                    <button type="button"
                                        class="btn btn--base btn--sm outline <?php if($deposit->method_code >= 1000): ?> detailBtn <?php else: ?> disabled <?php endif; ?>"
                                        <?php if($deposit->method_code >= 1000): ?> data-info="<?php echo e($details); ?>" <?php endif; ?>
                                        <?php if($deposit->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($deposit->admin_feedback); ?>" <?php endif; ?>>
                                        <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo userTableEmptyMessage('deposit') ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($deposits->hasPages()): ?>
                <?php echo e(paginateLinks($deposits)); ?>

            <?php endif; ?>
        </div>
    </div>


    
    <div id="detailModal" class="modal fade custom--modal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Deposit Details'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData mb-2 list-group-flush"></ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>


<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');

                var userData = $(this).data('info');
                var html = '';
                if (userData) {
                    userData.forEach(element => {
                        if (element.type != 'file') {
                            html += `
                            <li class="list-group-item d-flex justify-content-between align-items-center ps-0">
                                <span>${element.name}</span>
                                <span">${element.value}</span>
                            </li>`;
                        }
                    });
                }

                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);
                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/deposit_history.blade.php ENDPATH**/ ?>