<?php $__env->startSection('content'); ?>
    <div class="row gy-4">
        <div class="col-lg-12">
            <div class="d-flex flex-between flex-wrap align-items-center">
                <h5 class="title mb-0"><?php echo e(__($pageTitle)); ?></h5>
                <a href="<?php echo e(route('ticket.index')); ?>" class="btn btn--base btn--sm outline">
                    <i class="las la-list"></i> <?php echo app('translator')->get('My Tickets'); ?>
                </a>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="card custom--card">
                <div class="card-body">
                    <form action="<?php echo e(route('ticket.store')); ?>" method="post" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="row gy-3">
                            <div class="col-md-6 form-group">
                                <label class="form-label"><?php echo app('translator')->get('Name'); ?></label>
                                <input type="text" name="name" value="<?php echo e(@$user->firstname . ' ' . @$user->lastname); ?>"
                                    class="form-control form--control" required readonly>
                            </div>
                            <div class="col-md-6 form-group">
                                <label class="form-label"><?php echo app('translator')->get('Email Address'); ?></label>
                                <input type="email" name="email" value="<?php echo e(@$user->email); ?>" class="form-control form--control" required readonly>
                            </div>

                            <div class="col-md-6 form-group">
                                <label class="form-label"><?php echo app('translator')->get('Subject'); ?></label>
                                <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" class="form-control form--control" required>
                            </div>
                            <div class="col-md-6 form-group position-relative" >
                                <label class="form-label"><?php echo app('translator')->get('Priority'); ?></label>
                                <select name="priority" class="form-control form--control select2" required data-minimum-results-for-search="-1" data-width="100%">
                                    <option value="3"><?php echo app('translator')->get('High'); ?></option>
                                    <option value="2"><?php echo app('translator')->get('Medium'); ?></option>
                                    <option value="1"><?php echo app('translator')->get('Low'); ?></option>
                                </select>
                            </div>
                            <div class="col-12">
                                <label class="form-label required"><?php echo app('translator')->get('Message'); ?></label>
                                <textarea name="message" id="inputMessage" rows="6" class="form-control form--control" required><?php echo e(old('message')); ?></textarea>
                            </div>

                            <div class="col-md-9">
                                <button type="button" class="btn btn-dark btn-sm addAttachment my-2"> <i class="fas fa-plus"></i> <?php echo app('translator')->get('Add Attachment'); ?>
                                </button>
                                <p class="mb-2"><span class="text--info"><?php echo app('translator')->get('Max 5 files can be uploaded | Maximum upload size is ' . convertToReadableSize(ini_get('upload_max_filesize')) . ' | Allowed File Extensions: .jpg, .jpeg, .png, .pdf, .doc, .docx'); ?></span></p>
                                <div class="row fileUploadsContainer">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <button class="btn btn--base w-100 my-2" type="submit"><i class="las la-paper-plane"></i> <?php echo app('translator')->get('Submit'); ?>
                                </button>
                            </div>

                            <div class="form--group col-sm-12 attachment-wrapper d-none">
                                <div class="file-upload"></div>
                                
                                <p class="ticket-attachments-message text-muted mt-2">
                                    <?php echo app('translator')->get('Allowed File Extensions'); ?>: .<?php echo app('translator')->get('jpg'); ?>, .<?php echo app('translator')->get('jpeg'); ?>, .<?php echo app('translator')->get('png'); ?>,
                                    .<?php echo app('translator')->get('pdf'); ?>, .<?php echo app('translator')->get('doc'); ?>, .<?php echo app('translator')->get('docx'); ?>. &nbsp;
                                    <small class="text--danger"><?php echo app('translator')->get('Max 5 files can be uploaded'); ?>. <?php echo app('translator')->get('Maximum upload size is'); ?> <?php echo e(ini_get('upload_max_filesize')); ?>

                                    </small>
                                </p>
                            </div>
                            <div class="col-12">
                                <div id="fileUploadsContainer"></div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>



<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>






<?php $__env->startPush('script'); ?>
    <script>
        (function ($) {
            "use strict";

         

            var fileAdded = 0;
            $('.addAttachment').on('click',function(){
                fileAdded++;
                if (fileAdded == 5) {
                    $(this).attr('disabled',true)
                }
                $(".fileUploadsContainer").append(`
                    <div class="col-lg-4 col-md-12 removeFileInput">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="file" name="attachments[]" class="form-control form--control" accept=".jpeg,.jpg,.png,.pdf,.doc,.docx" required>
                                <button type="button" class="input-group-text removeFile bg--danger border--danger"><i class="fas fa-times"></i></button>
                            </div>
                        </div>
                    </div>
                `)
            });
            $(document).on('click','.removeFile',function(){
                $('.addAttachment').removeAttr('disabled',true)
                fileAdded--;
                $(this).closest('.removeFileInput').remove();
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/support/create.blade.php ENDPATH**/ ?>