<?php $__env->startSection('main-content'); ?>
    <?php if(gs('registration')): ?>


        <?php
            $languages = App\Models\Language::get();
            $content = getContent('register.content', true);
            $langDetails = $languages->where('code', config('app.locale'))->first();
            $credentials = gs('socialite_credentials');
        ?>

        <section class="account">
            <div class="account-inner">
                <div class="account-left">
                    <a href="<?php echo e(route('home')); ?>" class="account-left__logo">
                        <img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_base.png')); ?>">
                    </a>
                    <div class="account-left__content">
                        <h5 class="account-left__subtitle-two mb-0">
                            <?php echo e(__(@$content->data_values->title)); ?>

                        </h5>
                        <h3 class="account-left__title-two">
                            <?php echo highLightedString(@$content->data_values->heading_one,'account-left__title-two-style')  ?>
                        </h3>
                    </div>
                    <div class="account-left__thumb-two">
                        <img
                             src="<?php echo e(getImage('assets/images/frontend/register/' . @$content->data_values->image, '600x600')); ?>">
                    </div>
                </div>
                <div class="account-right-wrapper">
                    <div class="account-content__top">
                        <div class="account-content__member gap-2">
                            <p class="account-content__member-text"> <?php echo app('translator')->get('Already have an account'); ?>? </p>
                            <a href="<?php echo e(route('user.login')); ?>" class="account-link"> <?php echo app('translator')->get('Sign In'); ?> </a>
                            <?php if(gs('multi_language')): ?>
                                <div class="custom--dropdown">
                                    <div class="custom--dropdown__selected dropdown-list__item">
                                        <div class="thumb">
                                            <img
                                                 src="<?php echo e(getImage(getFilePath('language') . '/' . @$langDetails->flag, getFileSize('language'))); ?>">
                                        </div>
                                        <span class="text"><?php echo e(__(@$langDetails->name)); ?></span>
                                    </div>
                                    <ul class="dropdown-list">
                                        <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <li class="dropdown-list__item change-lang " data-code="<?php echo e(@$language->code); ?>">
                                                <div class="thumb">
                                                    <img
                                                         src="<?php echo e(getImage(getFilePath('language') . '/' . @$language->flag, getFileSize('language'))); ?>">
                                                </div>
                                                <span class="text"><?php echo e(__(@$language->name)); ?></span>
                                            </li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                            
                            <div id="google_translate_element"></div>
<script type="text/javascript">
  function googleTranslateElementInit() {
    new google.translate.TranslateElement(
      { pageLanguage: 'en', layout: google.translate.TranslateElement.InlineLayout.HORIZONTAL },
      'google_translate_element'
    );
  }
</script>
<script type="text/javascript" src="//translate.google.com/translate_a/element.js?cb=googleTranslateElementInit"></script>
                            <div class="theme-switch-wrapper">
                                <label class="theme-switch" for="checkbox">
                                    <input type="checkbox" class="d-none" id="checkbox">
                                    <span class="slider">
                                        <i class="las la-sun"></i>
                                    </span>
                                </label>
                            </div>
                        </div>
                    </div>
                    <div class="account-right">
                        <div class="account-content">
                            <div class="account-form">
                                <h3 class="account-form__title mb-0"> <?php echo e(__(@$content->data_values->heading_two)); ?></h3>
                                <p class="account-form__desc"><?php echo e(__(@$content->data_values->subheading_two)); ?></p>
                                <?php echo $__env->make($activeTemplate . 'partials.social_loign', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                                <form action="<?php echo e(route('user.register')); ?>" method="POST" class="verify-gcaptcha">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <?php if(session()->get('reference') != null): ?>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label for="referenceBy" class="form--label"><?php echo app('translator')->get('Reference by'); ?></label>
                                                    <input type="text" name="referBy" id="referenceBy"
                                                           class="form--control" value="<?php echo e(session()->get('reference')); ?>"
                                                           readonly>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('First Name'); ?></label>
                                                <input type="text" class="form--control" name="firstname"
                                                       value="<?php echo e(old('firstname')); ?>" required
                                                       placeholder="<?php echo app('translator')->get('Your First Name'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('Last Name'); ?></label>
                                                <input type="text" class="form--control" name="lastname"
                                                       value="<?php echo e(old('lastname')); ?>" required placeholder="<?php echo app('translator')->get('Your Last Name'); ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('E-Mail Address'); ?></label>
                                                <input type="email" class="form--control checkUser"
                                                       placeholder="<?php echo app('translator')->get('Your email'); ?>" name="email"
                                                       value="<?php echo e(old('email')); ?>" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('Password'); ?></label>
                                                <input type="password"
                                                       class="form--control <?php if(gs('secure_password')): ?> secure-password <?php endif; ?>"
                                                       name="password" placeholder="<?php echo app('translator')->get('Your password'); ?>" required
                                                       autocomplete="off">
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label"><?php echo app('translator')->get('Confirm Password'); ?></label>
                                                <input type="password" class="form--control" name="password_confirmation"
                                                       placeholder="<?php echo app('translator')->get('Password Confirmation'); ?>" required>
                                            </div>
                                        </div>
                                        <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['isCustom' => 'true']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                    </div>
                                    <?php if(gs('agree')): ?>
                                        <?php
                                            $policyPages = getContent('policy_pages.element', false, null, true);
                                        ?>
                                        <div class="form-group">
                                            <input type="checkbox" id="agree" <?php if(old('agree')): echo 'checked'; endif; ?>
                                                   name="agree" required>
                                            <label for="agree"><?php echo app('translator')->get('I agree with'); ?></label>
                                            <span>
                                                <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policy): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <a class="text--base"
                                                       href="<?php echo e(route('policy.pages', $policy->slug)); ?>"
                                                       target="_blank"><?php echo e(__($policy->data_values->title)); ?></a>
                                                    <?php if(!$loop->last): ?>
                                                        ,
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </span>
                                        </div>
                                    <?php endif; ?>
                                    <button type="submit" id="recaptcha" class="btn btn--base w-100">
                                        <?php echo app('translator')->get('Register'); ?></button>
                                </form>
                            </div>
                        </div>
                    </div>
                    <div class="row gy-3 mt-auto">
                        <div class="col-md-6">
                            <div class="bottom-footer__text"> <?php echo copyRightText(); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <div class="modal fade custom--modal" id="existModalCenter" tabindex="-1" role="dialog"
             aria-labelledby="existModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="existModalLongTitle"><?php echo app('translator')->get('You are with us'); ?></h5>
                        <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                            <i class="las la-times"></i>
                        </span>
                    </div>
                    <div class="modal-body">
                        <h6 class="text-center"><?php echo app('translator')->get('You already have an account please Login '); ?></h6>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn--dark btn--sm"
                                data-bs-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        <a href="<?php echo e(route('user.login')); ?>" class="btn btn--base btn--sm"><?php echo app('translator')->get('Login'); ?></a>
                    </div>
                </div>
            </div>
        </div>
    <?php else: ?>
        <?php echo $__env->make($activeTemplate . 'partials.registration_disabled', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('style'); ?>
    <style>
        .country-code .input-group-text {
            background: #fff !important;
        }

        .country-code select {
            border: none;
        }

        .country-code select:focus {
            border: none;
            outline: none;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php if(gs('secure_password')): ?>
    <?php $__env->startPush('script-lib'); ?>
        <script src="<?php echo e(asset('assets/global/js/secure_password.js')); ?>"></script>
    <?php $__env->stopPush(); ?>
<?php endif; ?>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {

            $('.checkUser').on('focusout', function(e) {
                var url = '<?php echo e(route('user.checkUser')); ?>';
                var value = $(this).val();
                var token = '<?php echo e(csrf_token()); ?>';

                var data = {
                    email: value,
                    _token: token
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $('#existModalCenter').modal('show');
                    }
                });
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/auth/register.blade.php ENDPATH**/ ?>