<?php
$content          = getContent('crypto_currency.content',true);
$cryptoCurrencies = App\Models\Currency::whereHas('marketData')->with('marketData:id,currency_id,html_classes,percent_change_1h,price,last_price')->crypto()->rankOrdering()->take(8)->get();
?>

<section  class="currency-section py-120 section-bg">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="section-heading">
                    <h2 class="section-heading__title"> <?php echo e(__(@$content->data_values->heading)); ?> </h2>
                    <p class="section-heading__desc"><?php echo e(__(@$content->data_values->subheading)); ?> </p>
                </div>
            </div>
        </div>
        <div class="row justify-content-center gy-4" id="crypto-wrapper">
            <?php $__empty_1 = true; $__currentLoopData = $cryptoCurrencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cryptoCurrency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $marketData=@$cryptoCurrency->marketData;
            ?>
            <div class="col-xl-3 col-lg-4 col-md-4 col-sm-6 col-xsm-6">
                <div class="currency-item crypto-<?php echo e($cryptoCurrency->symbol); ?>">
                    <div class="d-flex justify-content-between">
                        <div class="d-flex justify-content-between">
                            <span class="currency-item__icon">
                                <img src="<?php echo e($cryptoCurrency->imageUrl); ?>">
                            </span>
                            <div class="currency-item__coin">
                                <h6 class="currency-item__coin-title"><?php echo e(__($cryptoCurrency->symbol)); ?></h6>
                                <span class="currency-item__coin-name"> <?php echo e(__($cryptoCurrency->name)); ?> </span>
                            </div>
                        </div>
                    </div>
                    <div class="currency-item__content">
                        <h4 class="currency-item__content-number fs-18">
                            <span>
                                <span class="market-price-symbol-<?php echo e(@$marketData->id); ?> <?php echo e(@$marketData->html_classes->price_change); ?>">
                                    <?php echo e(gs('cur_sym')); ?>

                                </span><span class="market-price-<?php echo e(@$marketData->id); ?> <?php echo e(@$marketData->html_classes->price_change); ?>">
                                    <?php echo e(showAmount($cryptoCurrency->marketData->price,currencyFormat:false)); ?>

                                </span>
                            </span>
                            <span> - </span>
                            <span class="market-percent-change-1h-<?php echo e(@$marketData->id); ?> <?php echo e(@$marketData->html_classes->percent_change_1h); ?>">
                                <?php echo e(showAmount($marketData->percent_change_1h,2,currencyFormat:false)); ?>%
                            </span>
                        </h4>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-thumb text-center">
                <img src="<?php echo e(asset('assets/images/extra_images/empty.png')); ?>" />
                <p class="fs-14"><?php echo app('translator')->get('No crypto currency found'); ?></p>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<?php if(!app()->offsetExists('pusher_script')): ?>
<?php $__env->startPush('script-lib'); ?>
<script src="<?php echo e(asset('assets/global/js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/broadcasting.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php app()->offsetSet('pusher_script',true) ?>
<?php endif; ?>


<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function ($) {
            <?php if(!app()->offsetExists('lisiten_market_data_event')): ?>
                pusherConnection('market-data', marketChangeHtml);
                <?php app()->offsetSet('lisiten_market_data_event',true) ?>
            <?php endif; ?>
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>




<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/sections/crypto_currency.blade.php ENDPATH**/ ?>