<?php
    $footer      = getContent('footer.content', true);
    $socialIcons = getContent('social_icon.element', orderById: true);
    $policyPages = getContent('policy_pages.element');
?>

<footer class="footer-area">
    <div class="py-60">
        <div class="container">
            <div class="row gy-4 justify-content-center">
                <div class="col-sm-6 col-xl-6">
                    <div class="footer-item">
                        <div class="footer-item__logo">
                            <a href="<?php echo e(route('home')); ?>">
                                <img src="<?php echo e(siteLogo()); ?>">
                            </a>
                        </div>
                        <p class="footer-item__desc"><?php echo e(__(@$footer->data_values->about_info)); ?></p>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-2">
                    <div class="footer-item">
                        <h5 class="footer-item__title"><?php echo app('translator')->get('Quick Links'); ?></h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('trade')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Trade'); ?> </a>
                            </li>
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('market')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Market'); ?> </a>
                            </li>
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('crypto_currencies')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Crypto Currency'); ?> </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-2">
                    <div class="footer-item">
                        <h5 class="footer-item__title"> <?php echo app('translator')->get('Company'); ?> </h5>
                        <ul class="footer-menu">
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('home')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Home'); ?> </a>
                            </li>
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('about')); ?>" class="footer-menu__link"><?php echo app('translator')->get('About'); ?></a>
                            </li>
                            <li class="footer-menu__item">
                                <a href="<?php echo e(route('contact')); ?>" class="footer-menu__link"> <?php echo app('translator')->get('Contact'); ?> </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-sm-6 col-xl-2">
                    <div class="footer-item">
                        <h5 class="footer-item__title"> <?php echo app('translator')->get('Legal'); ?> </h5>
                        <ul class="footer-menu">
                            <?php $__currentLoopData = $policyPages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $policyPage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="footer-menu__item">
                                    <a href="<?php echo e(route('policy.pages', @$policyPage->slug)); ?>"
                                        class="footer-menu__link">
                                        <?php echo e(__($policyPage->data_values->title)); ?>

                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="bottom-footer">
        <div class="container">
            <div class="bottom-footer__style py-3">
                <div class="gap-4 d-flex flex-wrap justify-content-between align-items-center">
                    <div class="bottom-footer__text">
                        <?php echo copyRightText(); ?>
                    </div>
                    <div class="footer-list-wrapper">
                        <ul class="social-list">
                            <?php $__currentLoopData = $socialIcons; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sIcon): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="social-list__item">
                                    <a href="<?php echo e(@$sIcon->data_values->url); ?>" target="_blank" class="social-list__link">
                                        <?php echo @$sIcon->data_values->icon; ?>
                                    </a>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</footer>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/partials/footer.blade.php ENDPATH**/ ?>