<?php
$content = getContent('subscribe.content',true);
?>
<section class="subscribe-section py-120">
    <div class="container">
        <div class="subscribe-wrapper section-bg">
            <div class="subscribe-wrapper__shape">
                <img src="<?php echo e(getImage('assets/images/frontend/subscribe/'.@$content->data_values->shape_image_one,'30x30')); ?>">
            </div>
            <div class="subscribe-wrapper__shape-one">
                <img src="<?php echo e(getImage('assets/images/frontend/subscribe/'.@$content->data_values->shape_image_one,'30x30')); ?>">
            </div>
            <div class="row justify-content-center gy-4 align-items-center">
                <div class="col-lg-6">
                    <div class="subscribe-wrapper__thumb">
                        <img src="<?php echo e(getImage('assets/images/frontend/subscribe/'.@$content->data_values->image,'500x330')); ?>">
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="subscribe-wrapper__item">
                        <span class="subscribe-wrapper__subtitle">
                            <?php echo __(@$content->data_values->heading); ?>
                        </span>
                        <h3 class="subscribe-wrapper__title"> <?php echo __(@$content->data_values->subheading); ?> </h3>
                        <form class="subscribe-wrapper__form d-flex justify-content-between " id="subscribe-form">
                            <input type="email" name="email" class="form--control" placeholder="<?php echo e(__(@$content->data_values->placeholder)); ?>">
                            <button class="btn btn--base" type="submit"> <?php echo e(__(@$content->data_values->button_text)); ?> </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php $__env->startPush('script'); ?>
<script>
    "use strict";
    (function ($) {
        $('#subscribe-form').on('submit', function (e) {
            e.preventDefault();
            let formData = new FormData($(this)[0]);
            let $this    = $(this);
            $.ajax({
                headers: { 'X-CSRF-TOKEN': "<?php echo e(csrf_token()); ?>" },
                url: "<?php echo e(route('subscribe')); ?>",
                method: "POST",
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                beforeSend: function () {
                    $this.find('button[type=submit]').html(`
                        <span class="right-sidebar__button-icon">
                            <i class="las la-spinner la-spin"></i>
                        </span>`
                    ).attr('disabled',true);
                },
                complete: function (e) {
                    $this.find('button[type=submit]').html(`<?php echo e(__(@$content->data_values->button_text)); ?>`
                    ).attr('disabled', false);
                },
                success: function (resp) {
                    if (resp.success) {
                        notify('success', resp.message);
                    } else {
                        notify('error', resp.message || resp.error);
                    }
                }
            });
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/sections/subscribe.blade.php ENDPATH**/ ?>