<?php
    $meta = (object) $meta;
    $pair = @$meta->pair;
?>
<div class=" <?php if(@$meta->screen == 'small'): ?> col-sm-12  d-xl-none d-block <?php else: ?> d-xl-block d-none <?php endif; ?> ">
    <div class="trading-header skeleton selected-pair">
        <h4 class="trading-header__title"> <?php echo e(str_replace('_', '/', $pair->symbol)); ?> </h4>
        <div>
            <span class="text--base fs-12"><?php echo app('translator')->get('Price'); ?></span>
            <p class="trading-header-number">
                <span
                    class="market-price-<?php echo e(@$pair->marketData->id); ?> <?php echo e(@$pair->marketData->html_classes->price_change); ?>">
                    <?php echo e(showAmount(@$pair->marketData->price,currencyFormat:false)); ?>

                </span>
            </p>
        </div>
        <div>
            <span class="text--base fs-12"><?php echo app('translator')->get('Last Price'); ?></span>
            <p class="trading-header-number market-last-price-<?php echo e(@$pair->marketData->id); ?> ">
                <?php echo e(showAmount(@$pair->marketData->last_price,currencyFormat:false)); ?></p>
        </div>
        <div>
            <span class="text--base fs-12"> <?php echo app('translator')->get('1H Change'); ?> </span>
            <p class="trading-header__number ">
                <span
                    class="market-percent-change-1h-<?php echo e(@$pair->marketData->id); ?> <?php echo e(@$pair->marketData->html_classes->percent_change_1h); ?>">
                    <?php echo e(getAmount(@$pair->marketData->percent_change_1h, 2)); ?>%
                </span>
            </p>
        </div>
        <div>
            <span class="text--base fs-12"> <?php echo app('translator')->get('24H Change'); ?> </span>
            <p class="trading-header__number <?php echo e(@$pair->marketData->html_classes->percent_change_24h); ?>">
                <?php echo e(getAmount(@$pair->marketData->percent_change_24h, 2)); ?>%
            </p>
        </div>
        <div>
            <span class="text--base fs-12"><?php echo app('translator')->get('Marketcap'); ?></span>
            <p class="trading-header__number"> <?php echo e(showAmount(@$pair->marketData->market_cap,currencyFormat:false)); ?> </p>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        (function($) {
            setTimeout(() => {
                $('.selected-pair').removeClass('skeleton');
            }, 1500);
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/trade/pair.blade.php ENDPATH**/ ?>