<div class="table-wrapper">
    <?php if($trades->count()): ?>
        <table class="table table--responsive--lg">
            <thead>
                <tr>
                    <th><?php echo app('translator')->get('Type | Status'); ?></th>
                    <th><?php echo app('translator')->get('Order ID | Date'); ?></th>
                    <th><?php echo app('translator')->get('Buyer | Seller'); ?></th>
                    <th><?php echo app('translator')->get('Rate | Payment Method'); ?></th>
                    <th><?php echo app('translator')->get('Asset | Fiat'); ?></th>
                    <th><?php echo app('translator')->get('Action'); ?></th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <div>
                                <?php if(@$trade->ad->user_id == $user->id): ?>
                                    <?php echo $trade->ad->typeBadge ?>
                                <?php else: ?>
                                    <?php echo $trade->typeBadge; ?>
                                <?php endif; ?>
                                <div class="mt-1">
                                    <?php echo $trade->statusBadge; ?>
                                </div>
                            </div>
                        </td>
                        <td>
                            <div>
                                <span class="d-block"> <?php echo e($trade->uid); ?> </span>
                                <span><?php echo e(showDateTime($trade->created_at)); ?> </span>
                            </div>
                        </td>
                        <td>
                            <div>
                                <span class="d-block text--success">
                                    <?php echo e($user->id == @$trade->buyer_id ? __('ME') : @$trade->buyer->full_name); ?>

                                </span>
                                <span class="d-block text--danger">
                                    <?php echo e($user->id == @$trade->seller_id ? __('ME') : @$trade->seller->full_name); ?>

                                </span>
                            </div>
                        </td>
                        <td>
                            <div>
                                <span class="d-block">
                                    <?php echo e(showAmount(@$trade->ad->price,currencyFormat:false)); ?> <?php echo e(__(@$trade->ad->fiat->symbol)); ?> /
                                    <?php echo e(__(@$trade->ad->asset->symbol)); ?>

                                </span>
                                <span><?php echo e(__(@$trade->paymentMethod->name)); ?></span>
                            </div>
                        </td>
                        <td>
                            <div>
                                <span class="d-block">
                                    <?php echo e(showAmount(@$trade->asset_amount,currencyFormat:false)); ?> <?php echo e(__(@$trade->ad->asset->symbol)); ?>

                                </span>
                                <span>
                                    <?php echo e(showAmount(@$trade->fiat_amount,currencyFormat:false)); ?> <?php echo e(__(@$trade->ad->fiat->symbol)); ?>

                                </span>
                            </div>
                        </td>
                        <td>
                            <a href="<?php echo e(route('user.p2p.trade.details', $trade->id)); ?>"
                                class="btn btn--base btn--sm outline">
                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                            </a>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
    <?php else: ?>
        <?php echo userTableEmptyMessage("trade"); ?>
    <?php endif; ?>
</div>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/p2p/trade/table.blade.php ENDPATH**/ ?>