<?php $__env->startSection('content'); ?>
    <div class="row justify-content-end gy-3 align-items-center justify-content-between">
        <div class="col-lg-3">
            <h4 class="mb-0"><?php echo e(__($pageTitle)); ?></h4>
        </div>
        <div class="col-lg-3">
            <div class="d-flex gap-3">
                <form action="" class="flex-fill">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>"
                            placeholder="<?php echo app('translator')->get('Search by transactions'); ?>">
                        <button class="input-group-text bg-primary text-white">
                            <i class="las la-search"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="table-wrapper">
                <table class="table table--responsive--lg">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Currency | Wallet'); ?></th>
                            <th><?php echo app('translator')->get('Gateway | Transaction'); ?></th>
                            <th><?php echo app('translator')->get('Initiated'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Status'); ?></th>
                            <th><?php echo app('translator')->get('Action'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $withdraws; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>

                            <tr>
                                <td>
                                    <div>
                                        <span><?php echo e(@$withdraw->wallet->currency->symbol); ?></span>
                                        <br>
                                        <small><?php echo e(@$withdraw->wallet->name); ?> | <?php echo e(__(strtoupper(@$withdraw->wallet->type_text))); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <div>
                                        <span class="fw-bold"><span class="text-primary">
                                                <?php echo e(__(@$withdraw->method->name)); ?></span></span>
                                        <br>
                                        <small><?php echo e($withdraw->trx); ?></small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <?php echo e(showDateTime($withdraw->created_at)); ?> <br>
                                        <?php echo e(diffForHumans($withdraw->created_at)); ?>

                                    </div>
                                </td>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <?php echo e(showAmount($withdraw->amount,currencyFormat:false)); ?> - <span class="text--danger"
                                            title="<?php echo app('translator')->get('charge'); ?>"><?php echo e(showAmount($withdraw->charge,currencyFormat:false)); ?> </span>
                                        <br>
                                        <strong title="<?php echo app('translator')->get('Amount after charge'); ?>">
                                            <?php echo e(showAmount($withdraw->amount - $withdraw->charge,currencyFormat:false)); ?>

                                            <?php echo e(@$withdraw->currency); ?>

                                        </strong>
                                    </div>
                                </td>
                                <td class="text-center">
                                    <div class="text-end text-lg-start">
                                        <?php echo $withdraw->statusBadge ?>
                                    </div>
                                </td>
                                <td>
                                    <button class="btn btn--sm btn--base detailBtn outline"
                                        data-user_data="<?php echo e(json_encode($withdraw->withdraw_information)); ?>"
                                        <?php if($withdraw->status == Status::PAYMENT_REJECT): ?> data-admin_feedback="<?php echo e($withdraw->admin_feedback); ?>" <?php endif; ?>>
                                        <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo userTableEmptyMessage('withdraw ') ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($withdraws->hasPages()): ?>
                <?php echo e(paginateLinks($withdraws)); ?>

            <?php endif; ?>
        </div>
    </div>


    
    <div id="detailModal" class="modal fade custom--modal" tabindex="-1" role="dialog">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo app('translator')->get('Details'); ?></h5>
                    <span type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="las la-times"></i>
                    </span>
                </div>
                <div class="modal-body">
                    <ul class="list-group userData list-group-flush">

                    </ul>
                    <div class="feedback"></div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        (function($) {
            "use strict";
            $('.detailBtn').on('click', function() {
                var modal = $('#detailModal');
                var userData = $(this).data('user_data');
                var html = ``;
                userData.forEach(element => {
                    if (element.type != 'file') {
                        html += `
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <span>${element.name}</span>
                            <span">${element.value}</span>
                        </li>`;
                    }
                });
                modal.find('.userData').html(html);

                if ($(this).data('admin_feedback') != undefined) {
                    var adminFeedback = `
                        <div class="my-3">
                            <strong><?php echo app('translator')->get('Admin Feedback'); ?></strong>
                            <p>${$(this).data('admin_feedback')}</p>
                        </div>
                    `;
                } else {
                    var adminFeedback = '';
                }

                modal.find('.feedback').html(adminFeedback);

                modal.modal('show');
            });
        })(jQuery);
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/withdraw/log.blade.php ENDPATH**/ ?>