
<?php $__env->startSection('panel'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card  ">
                <div class="card-body p-0">
                    <div class="table-responsive--sm table-responsive">
                        <table class="table table--light style--two custom-data-table">
                            <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('Type'); ?></th>
                                    <th><?php echo app('translator')->get('Asset | Fiat'); ?></th>
                                    <th><?php echo app('translator')->get('Seller'); ?></th>
                                    <th><?php echo app('translator')->get('Buyer'); ?></th>
                                    <th><?php echo app('translator')->get('Order ID | Date'); ?></th>
                                    <th><?php echo app('translator')->get('Rate | Payment Method'); ?></th>
                                    <th><?php echo app('translator')->get('Status'); ?></th>
                                    <th><?php echo app('translator')->get('Action'); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $trades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trade): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td> <?php echo $trade->typeBadge; ?> </td>
                                        <td>
                                            <div>
                                                <span class="d-block">
                                                    <?php echo e(showAmount(@$trade->asset_amount, currencyFormat: false)); ?>

                                                    <?php echo e(__(@$trade->ad->asset->symbol)); ?>

                                                </span>
                                                <span>
                                                    <?php echo e(showAmount(@$trade->fiat_amount, currencyFormat: false)); ?>

                                                    <?php echo e(__(@$trade->ad->fiat->symbol)); ?>

                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="fw-bold"><?php echo e(@$trade->seller->fullname); ?></span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="<?php echo e(route('admin.users.detail', @$trade->seller->id)); ?>"><span>@</span><?php echo e(@$trade->seller->username); ?></a>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="fw-bold"><?php echo e(@$trade->buyer->fullname); ?></span>
                                            <br>
                                            <span class="small">
                                                <a
                                                    href="<?php echo e(route('admin.users.detail', @$trade->buyer->id)); ?>"><span>@</span><?php echo e(@$trade->buyer->username); ?></a>
                                            </span>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="d-block"> <?php echo e($trade->uid); ?> </span>
                                                <span><?php echo e(showDateTime($trade->created_at)); ?> </span>
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <span class="d-block">
                                                    <?php echo e(showAmount(@$trade->ad->price, currencyFormat: false)); ?>

                                                    <?php echo e(__(@$trade->ad->fiat->symbol)); ?>

                                                    /
                                                    <?php echo e(__(@$trade->ad->asset->symbol)); ?>

                                                </span>
                                                <span><?php echo e(__(@$trade->paymentMethod->name)); ?></span>
                                            </div>
                                        </td>
                                        <td> <?php echo $trade->statusBadge; ?> </td>
                                        <td>
                                            <a href="<?php echo e(route('admin.p2p.trade.details', $trade->id)); ?>" class="btn btn-sm btn-outline--primary">
                                                <i class="las la-desktop"></i> <?php echo app('translator')->get('Details'); ?>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <?php if($trades->hasPages()): ?>
                    <div class="card-footer py-4">
                        <?php echo e(paginateLinks($trades)); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('style'); ?>
    <style>
        .badge--info {
            background-color: #1e9ff290;
            border: 1px solid #1e9ff2;
            color: #000;
            font-weight: 600;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/admin/p2p/trade/index.blade.php ENDPATH**/ ?>