<?php $__env->startSection('content'); ?>
    <?php
        $banner   = getContent('banner.content', true);
        $elements = getContent('banner.element');
    ?>

    <section class="banner-section">
        <div class="banner-section__shape light-mood">
            <img src="<?php echo e(asset($activeTemplateTrue . 'images/shapes/banner_1.png')); ?>">
        </div>
        <div class="banner-section__shape dark-mood">
            <img src="<?php echo e(asset($activeTemplateTrue . 'images/shapes/banner_1_dark.png')); ?>">
        </div>
        <div class="banner-section__shape-one light-mood">
            <img src="<?php echo e(asset($activeTemplateTrue . 'images/shapes/bg.png')); ?>">
        </div>
        <div class="banner-section__shape-one dark-mood">
            <img src="<?php echo e(asset($activeTemplateTrue . 'images/shapes/bg_dark.png')); ?>">
        </div>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="banner-content ">
                        <h1 class="banner-content__title">
                            <?php echo highLightedString(@$banner->data_values->heading); ?>
                        </h1>
                        <p class="banner-content__desc">
                            <?php echo highLightedString(@$banner->data_values->subheading,'fw-bold'); ?>
                        </p>
                        <div class="banner-content__button d-flex align-items-center gap-3">
                            <a href="<?php echo e(@$banner->data_values->button_link); ?>" class="btn btn--base">
                                <?php echo e(__(@$banner->data_values->button_text)); ?>

                            </a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="banner-right">
                        <div class="banner-right__thumb">
                            <img src="<?php echo e(getImage('assets/images/frontend/banner/' . @$banner->data_values->image_one, '500x360')); ?>">
                            <div class="banner-right__thumb-shape">
                                <img src="<?php echo e(getImage('assets/images/frontend/banner/' . @$banner->data_values->image_two, '155x155')); ?>">
                            </div>
                        </div>
                        <div class="banner-right__shape">
                            <img src="<?php echo e(getImage('assets/images/frontend/banner/' . @$banner->data_values->image_three, '450x285')); ?>">
                        </div>
                        <div class="banner-right__bg">
                            <div class="banner-right__shape-bg-one bg"></div>
                            <div class="banner-right__shape-bg-two bg"></div>
                            <div class="banner-right__shape-bg-three bg"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="single-slider">
                        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="single-slider__item">
                                <span class="single-slider__desc">
                                    <span class="badge badge--success"><?php echo e(__(@$element->data_values->badge)); ?></span>
                                    <?php echo e(__(@$element->data_values->title)); ?>

                                    <a href="<?php echo e(@$element->data_values->link); ?>" class="single-slider__link"> <?php echo app('translator')->get('More'); ?> </a>
                                </span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php echo $__env->make($activeTemplate . 'sections.blog', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/slick.min.js')); ?>"></script>
    <script src="<?php echo e(asset($activeTemplateTrue . 'js/swiper.js')); ?>"></script>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/slick.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset($activeTemplateTrue . 'css/swiper.css')); ?>">
<?php $__env->stopPush(); ?>

<?php app()->offsetSet('swiper_assets',true) ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/home.blade.php ENDPATH**/ ?>