<?php $__env->startSection('main-content'); ?>
    <?php
        $content = getContent('account_recovery.content', true);
    ?>
    <section class="account">
        <div class="account-inner">
            <div class="account-left">
                <a href="<?php echo e(route('home')); ?>" class="account-left__logo">
                    <img src="<?php echo e(getImage(getFilePath('logoIcon') . '/logo_base.png')); ?>">
                </a>
                <div class="account-left__content">
                    <h5 class="account-left__subtitle mb-0"><?php echo e(__(@$content->data_values->title)); ?></h5>
                    <h3 class="account-left__title"><?php echo e(__(@$content->data_values->heading)); ?></h3>
                </div>
                <div class="account-left__thumb">
                    <img src="<?php echo e(getImage('assets/images/frontend/account_recovery/' . @$content->data_values->image, '600x600')); ?>">
                </div>
            </div>
            <div class="account-right-wrapper">
                <div class="account-right account-right-custom">
                    <div class="account-content">
                        <div class="account-form">
                            <h3 class="account-form__title mb-0"><?php echo app('translator')->get('Verify Email Address'); ?></h3>
                            <p class="account-form__desc">
                                <?php echo app('translator')->get('A 6 digit verification code sent to your email address'); ?> : <?php echo e(showEmailAddress($email)); ?>

                            </p>
                            <form action="<?php echo e(route('user.password.verify.code')); ?>" method="POST" class="submit-form">
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="email" value="<?php echo e($email); ?>">
                                <?php echo $__env->make($activeTemplate . 'partials.verification_code', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <div class="form-group">
                                    <button type="submit" class="btn btn--base w-100"><?php echo app('translator')->get('Submit'); ?></button>
                                </div>
                                <div class="form-group">
                                    <?php echo app('translator')->get('Please check including your Junk/Spam Folder. if not found, you can'); ?>
                                    <a class="text--base" href="<?php echo e(route('user.password.request')); ?>"><?php echo app('translator')->get('Try to send again'); ?></a>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/auth/passwords/code_verify.blade.php ENDPATH**/ ?>