<?php
    $topExchangesCoins = App\Models\Order::whereHas('coin', function ($q) {
        $q->active()->crypto();
        })->where('status', '!=', Status::ORDER_CANCELED)
        ->selectRaw('*,SUM(filled_amount) as total_exchange_amount')
        ->groupBy('coin_id')
        ->orderBy('total_exchange_amount', 'desc')
        ->take(4)
        ->with('coin', 'coin.marketData')
        ->get();
?>

<div class="market-overview-card">
    <div class="market-overview-card__header">
        <h6 class="mb-2"><?php echo app('translator')->get('Top Exchanges Coin'); ?></h6>
    </div>
    <div class="market-overview-card__list">
        <?php $__empty_1 = true; $__currentLoopData = $topExchangesCoins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $topExchangesCoin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <?php
                $marketData = @$topExchangesCoin->coin->marketData;
                $htmlClass = $marketData->html_classes;
            ?>
            <div class="market-overview-card__item">
                <span class="coin-name">
                    <img src="<?php echo e(@$topExchangesCoin->coin->image_url); ?>">
                    <?php echo e(@$topExchangesCoin->coin->symbol); ?>

                </span>
                <span class="coin-text">
                    <span class="market-price-symbol-<?php echo e(@$marketData->id); ?> <?php echo e(@$marketData->html_classes->price_change); ?>">
                        <?php echo e(gs("cur_sym")); ?>

                    </span><span class="market-price-<?php echo e(@$marketData->id); ?> <?php echo e(@$marketData->html_classes->price_change); ?>">
                        <?php echo e(showAmount($marketData->price,currencyFormat:false)); ?>

                    </span>
                </span>
                <span class="coin-percentage">
                    <span class="market-percent-change-1h-<?php echo e(@$marketData->id); ?> <?php echo e(@$htmlClass->percent_change_1h); ?>">
                        <?php echo e(getAmount(@$marketData->percent_change_1h)); ?>%
                    </span>
                </span>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="empty-thumb text-center">
                <img src="<?php echo e(asset('assets/images/extra_images/empty.png')); ?>" />
                <p class="fs-14"><?php echo app('translator')->get('No coin found'); ?></p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/coin/top_exchange_coin.blade.php ENDPATH**/ ?>