<?php $__env->startSection('content'); ?>
    <div class="row justify-content-center gy-2">
        <div class="col-lg-12">
            <div class="show-filter mb-3 text-end">
                <button type="button" class="btn btn--base showFilterBtn btn--sm"><i class="las la-filter"></i>
                    <?php echo app('translator')->get('Filter'); ?></button>
            </div>
            <div class="card responsive-filter-card mb-4">
                <div class="card-body">
                    <form action="">
                        <div class="d-flex flex-wrap gap-4">
                            <div class="flex-grow-1">
                                <label class="form-label"><?php echo app('translator')->get('Transaction Number'); ?></label>
                                <input type="text" name="search" value="<?php echo e(request()->search); ?>" class="form-control form--control">
                            </div>
                            <div class="flex-grow-1">
                                <label class="form-label"><?php echo app('translator')->get('Currency'); ?></label>
                                <div class="position-relative w-100">
                                    <select name="symbol" class="form-select form--control select2" data-width="100%">
                                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                                        <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($currency->symbol); ?>" <?php if(request()->symbol == $currency->symbol): echo 'selected'; endif; ?>>
                                                <?php echo e(__($currency->symbol)); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <label class="form-label"><?php echo app('translator')->get('Type'); ?></label>
                                <div class="position-relative w-100">
                                    <select name="trx_type" class="form-select form--control select2" data-minimum-results-for-search="-1"
                                        data-width="100%">
                                        <option value=""><?php echo app('translator')->get('All'); ?></option>
                                        <option value="+" <?php if(request()->trx_type == '+'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Plus'); ?></option>
                                        <option value="-" <?php if(request()->trx_type == '-'): echo 'selected'; endif; ?>><?php echo app('translator')->get('Minus'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <label class="form-label"><?php echo app('translator')->get('Remark'); ?></label>
                                <div class="position-relative w-100">
                                    <select class="form-select form--control select2" name="remark" data-width="100%">
                                        <option value=""><?php echo app('translator')->get('Any'); ?></option>
                                        <?php $__currentLoopData = $remarks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $remark): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($remark->remark); ?>" <?php if(request()->remark == $remark->remark): echo 'selected'; endif; ?>>
                                                <?php echo e(__(keyToTitle($remark->remark))); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="flex-grow-1 align-self-end">
                                <button class="btn btn--base w-100"><i class="las la-filter"></i> <?php echo app('translator')->get('Filter'); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="table-wrapper">
                <table class="table table--responsive--lg">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Currency | Wallet'); ?></th>
                            <th><?php echo app('translator')->get('Transacted'); ?></th>
                            <th><?php echo app('translator')->get('Trx'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Post Balance'); ?></th>
                            <th><?php echo app('translator')->get('Detail'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $curSymbol = @$trx->wallet->currency->symbol;
                            ?>
                            <tr>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <span><?php echo e($curSymbol); ?></span>
                                        <br>
                                        <small><?php echo e(@$trx->wallet->name); ?> | <?php echo e(__(strToUpper(@$trx->wallet->type_text))); ?> </small>
                                    </div>
                                </td>
                                <td>
                                    <div class="text-end text-lg-start">
                                        <?php echo e(showDateTime($trx->created_at)); ?><br><?php echo e(diffForHumans($trx->created_at)); ?>

                                    </div>
                                </td>
                                <td><?php echo e($trx->trx); ?></td>
                                <td>
                                    <span class="fw-bold <?php if($trx->trx_type == '+'): ?> text--success <?php else: ?> text--danger <?php endif; ?>">
                                        <?php echo e($trx->trx_type); ?> <?php echo e(showAmount($trx->amount, currencyFormat: false)); ?>

                                        <?php echo e($curSymbol); ?>

                                    </span>
                                </td>
                                <td> <?php echo e(showAmount($trx->post_balance, currencyFormat: false)); ?>

                                    <?php echo e($curSymbol); ?>

                                </td>
                                <td><?php echo e(__($trx->details)); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo userTableEmptyMessage('transactions') ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php if($transactions->hasPages()): ?>
                <?php echo e(paginateLinks($transactions)); ?>

            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('topContent'); ?>
    <h4 class="mb-4"><?php echo e(__($pageTitle)); ?></h4>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('script-lib'); ?>
    <script src="<?php echo e(asset('assets/global/js/select2.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('style-lib'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/user/transactions.blade.php ENDPATH**/ ?>