<?php $__empty_1 = true; $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <tr>
        <td>
            <div class="advertiser d-flex gap-2 align-items-center skeleton">
                <div class="advertiser__thumb">
                    <?php if(@$ad->user->image): ?>
                        <img class="fit-image" src="<?php echo e(getImage(getFilePath('userProfile') . '/' . @$ad->user->image, getFileSize('userProfile'), true)); ?>">
                    <?php else: ?>
                        <span class="user-short-name"><?php echo e(firstTwoCharacter(@$ad->user->fullname)); ?></span>
                    <?php endif; ?>
                </div>
                <div class="advertiser__content">
                    <h6 class="customer__name">
                        <a class="fw-normal" target="_blank" href="<?php echo e(route('p2p.advertiser', encrypt($ad->user->id))); ?>">
                            <?php echo e(__(@$ad->user->fullname)); ?>

                        </a>
                        <?php if($ad->user->kv): ?>
                            <span class="verified-profile">
                                <img data-bs-toggle="tooltip" title="<?php echo app('translator')->get('KYC Verified'); ?>" src="<?php echo e(asset('assets/images/extra_images/kyc.png')); ?>">
                            </span>
                        <?php endif; ?>
                    </h6>
                    <div class="advertiser__content-order-details d-flex align-items-center gap-1">
                        <span><?php echo e($ad->total_trade); ?></span>
                        <span>|</span>
                        <?php if($ad->total_trade > 0 && $ad->trades_count > 0): ?>
                            <span><?php echo e(( @$ad->trades_count / $ad->total_trade) *100); ?><?php echo app('translator')->get('% Completed'); ?></span>
                        <?php else: ?>
                            <?php echo app('translator')->get('0% Completed'); ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </td>
        <td>
            <div class="price fs-14 skeleton text--base">
                <span class="amount"><?php echo e(showAmount($ad->price,currencyFormat:false)); ?></span>
                <span class="currency"><?php echo e(__($ad->fiat->symbol)); ?></span>
            </div>
        </td>
        <td>
            <div class="price-limit skeleton">
                <p class="fs-14">
                    <?php echo e(showAmount($ad->balance,currencyFormat:false)); ?>

                    <span><?php echo e(__(@$ad->asset->symbol)); ?></span>
                </p>
                <p class="fs-14">
                    <?php echo e(showAmount($ad->minimum_amount,currencyFormat:false)); ?> - <?php echo e(showAmount($ad->maximum_amount,currencyFormat:false)); ?>

                    <?php echo e(__($ad->fiat->symbol)); ?>

                </p>
            </div>
        </td>
        <td>
            <span class="skeleton">
                <?php echo e(__(@$ad->paymentWindow->minute)); ?> <?php echo app('translator')->get('Minute'); ?>
            </span>
        </td>
        <td>
            <ul class="payment-list fs-14 skeleton">
                <?php $__currentLoopData = $ad->paymentMethods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $paymentMethod): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li class="payment-list__item danger">
                        <span class="color"
                            style="background-color: #<?php echo e(@$paymentMethod->paymentMethod->branding_color); ?>"></span>
                        <?php echo e(__(@$paymentMethod->paymentMethod->name)); ?>

                    </li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </td>
        <td>
            <?php if($type == 'buy'): ?>
                <button type="button" class="btn btn--success btn--sm trade-request" data-type="buy"
                    data-id="<?php echo e(encrypt($ad->id)); ?>" data-price="<?php echo e($ad->price); ?>"
                    data-min="<?php echo e($ad->minimum_amount); ?>" data-max="<?php echo e($ad->maximum_amount); ?>">
                    <?php echo app('translator')->get('Buy'); ?> <?php echo e(__(@$ad->asset->symbol)); ?>

                </button>
            <?php else: ?>
                <button type="button" class="btn btn--danger btn--sm trade-request" data-type="sell"
                    data-id="<?php echo e(encrypt($ad->id)); ?>" data-price="<?php echo e($ad->price); ?>"
                    data-min="<?php echo e($ad->minimum_amount); ?>" data-max="<?php echo e($ad->maximum_amount); ?>">
                    <?php echo app('translator')->get('Sell'); ?> <?php echo e(__(@$ad->asset->symbol)); ?>

                </button>
            <?php endif; ?>
        </td>
    </tr>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
    <?php echo userTableEmptyMessage('ad') ?>
<?php endif; ?>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/p2p/ad/list.blade.php ENDPATH**/ ?>