<?php
    $meta = (object) $meta;
    $pair = @$meta->pair;
    $marketCurrencyWallet = @$meta->marketCurrencyWallet;
    $screen = @$meta->screen;
?>

<form class="buy-sell-form buy-sell <?php if(@$meta->screen == 'small'): ?> buy-sell-one <?php endif; ?> buy--form" method="POST">
    <?php echo csrf_field(); ?>
    <?php if($meta->screen == 'small'): ?>
        <span class="sidebar__close"><i class="fas fa-times"></i></span>
    <?php endif; ?>
    <input type="hidden" name="order_side" value="<?php echo e(Status::BUY_SIDE_ORDER); ?>">
    <input type="hidden" name="order_type" value="<?php echo e(Status::ORDER_TYPE_LIMIT); ?>">
    <div class="flex-between buy-sell__wrapper">
        <h6 class="buy-sell__title"><?php echo app('translator')->get('Available'); ?></h6>
        <span class="fs-12">
            <span
                class="avl-market-cur-wallet"><?php echo e(showAmount(@$marketCurrencyWallet->balance, currencyFormat: false)); ?></span>
            <?php echo e(@$pair->market->currency->symbol); ?>

            <span class="cursor-pointer new--deposit" data-currency="<?php echo e(@$pair->market->currency->symbol); ?>">
                <i class="las la-plus-circle"></i>
            </span>
        </span>
    </div>

    <div class="buy-sell__price stop-limit-order d-none">
        <div class="input--group group-two">
            <span class="buy-sell__price-title fs-12"><?php echo app('translator')->get('Stop'); ?> </span>
            <span class="buy-sell__price-btc fs-12"> <?php echo e(@$pair->market->currency->symbol); ?> </span>
            <input type="number" step="any" class="form--control style-three" name="stop_rate"
                placeholder="<?php echo e(getAmount($pair->marketData->price)); ?>">
        </div>
    </div>
    <div class="buy-sell__price">
        <div class="input--group group-two">
            <span class="buy-sell__price-title fs-12">
                <span class="market-and-limit-order">
                    <?php echo app('translator')->get('Price'); ?>
                </span>
                <span class="stop-limit-order d-none">
                    <?php echo app('translator')->get('Limit'); ?>
                </span>
            </span>
            <span class="buy-sell__price-btc fs-12"> <?php echo e(@$pair->market->currency->symbol); ?> </span>
            <input type="number" step="any" class="form--control style-three buy-rate" name="rate"
                value="<?php echo e(getAmount($pair->marketData->price)); ?>">
        </div>
    </div>
    <div class="buy-sell__price">
        <div class="input--group group-two">
            <span class="buy-sell__price-title fs-12"><?php echo app('translator')->get('Amount'); ?> </span>
            <span class="buy-sell__price-btc fs-12"> <?php echo e(@$pair->coin->symbol); ?> </span>
            <input type="number" step="any" class="form--control style-three buy-amount"
                placeholder="<?php echo e(@$pair->buyPlaceHolder); ?>" name="amount">
        </div>
    </div>
    <div class="custom--range mt-2">
        <div class="buy-amount-slider custom--range__range slider-range"></div>
        <ul class="range-list buy-amount-range">
            <li class="range-list__number" data-percent="0"><?php echo app('translator')->get('0'); ?>%<span></span></li>
            <li class="range-list__number" data-percent="25"><?php echo app('translator')->get('25'); ?>%<span></span></li>
            <li class="range-list__number" data-percent="50"><?php echo app('translator')->get('50'); ?>%<span></span></li>
            <li class="range-list__number" data-percent="75"><?php echo app('translator')->get('75'); ?>%<span></span></li>
            <li class="range-list__number" data-percent="100"><?php echo app('translator')->get('100'); ?>%<span></span></li>
        </ul>
    </div>
    <div class="buy-sell__price pt-0 mb-2">
        <div class="input--group group-two">
            <span class="buy-sell__price-title fs-12"><?php echo app('translator')->get('Total'); ?> </span>
            <span class="buy-sell__price-btc fs-12"> <?php echo e(@$pair->market->currency->symbol); ?> </span>
            <input type="number" step="any" class="form--control style-three total-buy-amount"
                placeholder="<?php echo app('translator')->get('0.00'); ?>">
            <span class="fs-10 float-end mt-1 mb-2">
                <?php echo app('translator')->get('Fee'); ?> <?php echo e(getAmount($pair->percent_charge_for_buy)); ?>%
                <span class="buy-charge d-none"></span>
            </span>
        </div>
    </div>
    <div class="trading-bottom__button">
        <?php if(auth()->guard()->check()): ?>
            <button class="btn btn--base-two w-100 btn--sm  buy-btn " type="submit">
                <?php echo app('translator')->get('BUY'); ?> <?php echo e(__(@$pair->coin->symbol)); ?>

            </button>
        <?php else: ?>
            <div class="btn login-btn w-100 btn--sm">
                <a href="<?php echo e(route('user.login')); ?>"><?php echo app('translator')->get('Login'); ?></a>
                <span><?php echo app('translator')->get('or'); ?></span>
                <a href="<?php echo e(route('user.register')); ?>"><?php echo app('translator')->get('Register'); ?></a>
            </div>
        <?php endif; ?>
    </div>
</form>
<?php /**PATH /home/altabxhp/public_html/core/resources/views/templates/basic/trade/buy_form.blade.php ENDPATH**/ ?>