<?php include("connect.php"); ?>
<?php
// 1. Get Laravel's session ID from the vinance_session cookie
if (!isset($_COOKIE['vinance_session'])) {
    die("No Laravel session cookie found.");
}

$sessionId = $_COOKIE['vinance_session'];

// 2. Path to Laravel's session storage
$sessionPath = __DIR__ . '/core/storage/framework/sessions/' . $sessionId;

if (!file_exists($sessionPath)) {
    die("Session file not found.");
}

// 3. Read the file content
$contents = file_get_contents($sessionPath);

// 4. Remove Laravel's metadata
if (preg_match('/^.+?\|/', $contents, $matches)) {
    $contents = substr($contents, strlen($matches[0]));
}

// 5. Unserialize session data
$sessionData = unserialize($contents);

// 6. Get logged-in user ID from login_web_* key
$userId = null;
foreach ($sessionData as $key => $value) {
    if (strpos($key, 'login_web_') === 0) {
        $userId = $value;
        break;
    }
}

// Only echo if no login is found
if (!$userId) {
    echo "No active login found.";
}
else{
   
}
?>
<?php
$sql = "SELECT id, user_id, tname
        FROM cdetails
        WHERE user_id = '$userId' 
        ORDER BY id DESC 
        LIMIT 1";

$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    while ($rows = mysqli_fetch_assoc($result)) {
        $ids      = $rows['id'];
        $user_ids = $rows['user_id'];
        $tnames   = $rows['tname'];
    }
}

?>

<?php

$sql = "
SELECT o.*, cp.symbol 
FROM orders AS o
JOIN coin_pairs AS cp ON o.pair_id = cp.id
WHERE o.user_id = '$userId'
ORDER BY o.created_at DESC LIMIT 5
";

$result = mysqli_query($conn, $sql);

if ($result && mysqli_num_rows($result) > 0) {
    while ($row = mysqli_fetch_assoc($result)) {

        // Assign variables
        $id                 = $row['id'];
        $user_id            = $row['user_id'];
        $pair_id            = $row['pair_id'];
        $symbol             = $row['symbol']; // from coin_pairs
        $coin_id            = $row['coin_id'];
        $market_currency_id = $row['market_currency_id'];
        $trx                = $row['trx'];
        $order_side         = $row['order_side']; // 1=Buy, 2=Sell
        $order_type         = $row['order_type']; // 1=Limit, 2=Market, 3=Stop Limit
        $rate               = $row['rate'];
        $price              = $row['price'];
        $amount             = $row['amount'];
        $total              = ceil($row['total']);
        $filled_amount      = $row['filled_amount'];
        $filed_percentage   = $row['filed_percentage'];
        $charge             = $row['charge'];
        $stop_rate          = $row['stop_rate'];
        $is_draft           = $row['is_draft']; // 0=no, 1=yes
        $status             = $row['status']; // 0=Open, 1=Completed, 2=Pending, 9=Cancelled
        $created_at         = $row['created_at'];
        $updated_at         = $row['updated_at'];

        // Convert numeric values to readable text
        $side_text = ($order_side == 1) ? "Buy" : "Sell";

        switch ($status) {
            case 0: $status_text = "Open"; break;
            case 1: $status_text = "Completed"; break;
            case 2: $status_text = "Pending"; break;
            case 9: $status_text = "Cancelled"; break;
            default: $status_text = "Unknown";
        }

        // Date formatting
        $day  = date("d", strtotime($created_at));
        $month = strtoupper(date("M", strtotime($created_at)));

       // Output in desired format with styling

// Determine the color for the side_text
$side_color = (strtolower($side_text) === 'buy') ? '#28a745' : '#dc3545';

echo "
<div style='
    border: 1px solid #ddd;
    border-radius: 10px;
    padding: 15px;
    margin: 10px 0;
    background: ;
    font-family: Arial, sans-serif;
    box-shadow: 0 2px 5px rgba(0,0,0,0.05);
'>
    <div style='display: flex; align-items: center;'>
        <div style=\"
            background: #007bff;
            color: #fff;
            padding: 10px 15px;
            border-radius: 8px;
            text-align: center;
            font-weight: bold;
            font-size: 18px;
            margin-right: 15px;
            line-height: 1.2;
        \">
            {$day}<br>
            <span style='font-size: 12px; text-transform: uppercase;'>{$month}</span>
        </div>
        <div style='flex: 1;'>
            <div style='color: {$side_color}; font-weight: bold; font-size: 16px;'>{$side_text}</div>
            <div style='color: #fff; font-size: 14px; margin: 5px 0;'>
                Placed an order in the <strong>{$symbol}</strong> pair {$side_text} {$total} Dollars,  copied trade from <strong>{$tnames}</strong>
            </div>
            <div style='color: #28a745; font-weight: bold; font-size: 14px;'>{$status_text}</div>
        </div>
    </div>
</div>
";


    }
} else {
    echo "No records found.";
}

mysqli_close($conn);
?>


      